
void QtoV(char* ch_number)
{
   char fname[32];
   sprintf(fname, "../QtoV/%s.txt",ch_number);
   
   // Open file
   FILE* fp = fopen(fname,"r");
   if (fp==NULL) {
      fprintf(stderr,"error: failed to open %s\n",fname);
      return;
   }
   
   double charge[4];
   double volt[4];

   double charge_error[4];
   double volt_error[4];

   char line[256];
   int i=0;
 
   // Read data
   while (fgets(line,sizeof(line),fp)) {
      sscanf(line,"%lf %lf %lf %lf",&charge[i],&charge_error[i],&volt[i],&volt_error[i]);
      i++;
   }
   
   // Close file
   fclose(fp);

   for (int j=0; j<i; j++) {
      volt_error[i] = (volt_error[i] / sqrt(1000.0)) ;
   }
   
   int np = i;
   printf("number of points %d\n",np);

   gStyle->SetOptFit();
   TGraphErrors *gr1 = new TGraphErrors(np,charge,volt,charge_error,volt_error);
// gr1->SetMarkerStyle(20);
// gr1->SetMarkerColor(8);
// gr1->GetXaxis()->SetTitle("charge [fC]");
// gr1->GetYaxis()->SetTitle("volt [mV]");
// gr1->GetYaxis()->SetTitleOffset(1.5);
   gr1->Fit("pol1");
// gr1->Draw("A*");
   
   double inte;
   double grad;
   
   inte = gr1->GetFunction("pol1")->GetParameter(0);
   grad = gr1->GetFunction("pol1")->GetParameter(1);
   
   double ideal_volt[4];
   double div_volt[4];
   
   for (j=0; j<i; j++) {
      ideal_volt[j] = grad * charge[j] + inte ;
      div_volt[j]   = volt[j] - ideal_volt[j] ;
      if (div_volt[j]<0) {
         div_volt[j] = -div_volt[j];
      }
   }

// TCanvas *c2 = new TCanvas("c2","c2",600,400);
// c2->cd();
   TGraph *gr2 = new TGraph(np,charge,div_volt);
   gr2->SetMarkerStyle(20);
   gr2->SetMarkerColor(4);
   gr2->SetTitle(ch_number);
   gr2->GetXaxis()->SetTitle("charge [fC]");
   gr2->GetYaxis()->SetTitle("div volt [mV]");
   gr2->GetYaxis()->SetTitleOffset(1.4);
   gr2->Draw("A*");
// gr1->Draw("* same");
// c2->SetGrid();

}
