
#include <err.h>
#include <errno.h>
#include <stdio.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

struct packet_header{
   unsigned int MagicWord;
   unsigned int TYPE;
   unsigned int LENGTH;
   unsigned int NUMBER;
};

struct data_packet_header{
   unsigned short int type;
   unsigned char board_num;
   unsigned char ch_num;
   unsigned short int stop_num;
   unsigned short int data_length;
};

struct data_packet_footer{
   unsigned short int keyword;
   unsigned short int status;
};

int main() {
   int servSocket;
   int clntSocket;
   
   /* sockaddr_in */
   struct sockaddr_in servAddr;
   struct sockaddr_in clntAddr;
   int clntAddrSize = sizeof(clntAddr);
   
   /* parameter */
   struct packet_header sndHeader;
   struct data_packet_header data_header;
   unsigned int data_buffer[512];
   struct data_packet_footer data_footer;
   unsigned int Trailer;
   
   int packet_length;
   int packet_id;
   
   int i,j,k;
   
   for (k=0; k<512; k++) {
      data_buffer[k] = k;
   }
   
   data_footer.keyword = htons(0x5678);
   data_footer.status  = htons(0xCC00);
   
   /* sockaddr_in */
   memset(&servAddr, 0, sizeof(servAddr));
   servAddr.sin_port        = htons(50001);
   servAddr.sin_family      = AF_INET;
   //servAddr.sin_addr.s_addr = htonl(INADDR_ANY);
   servAddr.sin_addr.s_addr = inet_addr("192.168.10.3");
   
   /* make socket */
   if ((servSocket = socket(AF_INET, SOCK_STREAM, 0))<0) {
      perror("SOCKET");
      printf("make socket error\n");
      return -1;
   }
   
   /* bind socket */
   if ((bind(servSocket, (struct sockaddr *) &servAddr, sizeof(servAddr)))<0) {
      err(1,"BIND");
      printf("bind socket error\n");
      close(servSocket);
      return -1;
   }
   
   /* allowing of connection */
   if ((listen(servSocket, 1))<0) {
      err(1,"LISTEN");
      printf("Listen error\n");
      close(servSocket);
      return -1;
   }
   
   /* Accept for connection */
   printf("Waiting for connection ...\n");
// if ((clntSocket = accept(servSocket, NULL, NULL))<0) {
   if ((clntSocket = accept(servSocket, (struct sockaddr *) &clntAddr, &clntAddrSize))<0) {
      err(1,"ACCEPT");
   }
   printf("Connected from %s\n", inet_ntoa(clntAddr.sin_addr));
// printf("Accept\n");

   /* Send Packet */
   printf("Wait 10s ...\n");
   sleep(3);
   
   for (i=0; i<10; i++) {
      
      memset(&sndHeader,0,sizeof(sndHeader));
      
      sndHeader.MagicWord = htonl(0x89ABCDEF);
      sndHeader.TYPE      = htonl(0xFF000003);
      packet_length       = 2060 * 16;
      packet_id           = i + 1;
      sndHeader.LENGTH    = htonl(packet_length);
      sndHeader.NUMBER    = htonl(packet_id);
      
      send(clntSocket,&sndHeader,sizeof(sndHeader),0);
      
      for (j=0; j<16; j++) {
         memset(&data_header,0,sizeof(data_header));
         data_header.type        = htons(0x1234);
         data_header.board_num   = 0x03;
         data_header.ch_num      = j;
         data_header.stop_num    = htons(0x00FA);
         data_header.data_length = htons(2048);
         
         send(clntSocket,&data_header,sizeof(data_header),0);
         send(clntSocket,data_buffer,sizeof(data_buffer),0);
         send(clntSocket,&data_footer,sizeof(data_footer),0);
      }
      
      Trailer = htonl(0xFEDCBA98);
      send(clntSocket,&Trailer,sizeof(Trailer),0);
      printf("%d times packet send\n",i+1);
   }
   
   printf("Wait 1s ...\n");
   sleep(1);
   
   close(clntSocket);
   close(servSocket);
   
   printf("Close socket\n");
   
   return 0;
}
