
void CorrectionPed(char *run_number){

   gROOT->Reset();

   char filename[40];
   sprintf(filename,"../raw_data/%s.dat",run_number);
   
   FILE *fp;
   if ((fp = fopen(filename,"rb+"))==NULL){
      printf("File open Error\n");
      return -1;
   }
   
   TTree t("t","t");
   
   /*    */
   unsigned int  readnum;
   unsigned long long int totalread;
   unsigned char rawdata[33000];

   /*  Header/Footer Packet  */
   int MagicWord;
   int TYPE;
   unsigned int Length;
   unsigned int EventID;
   int Trailer;

   /*  Data Packet  */
   int hitnum;
   int DataType;
   int board_num;
   int ch_num;
   int stop_ID;
   int stop_ch;
   int data_length;
   int keyword;
   int status;
   int checksum;
   
   int data1[1024];
   int data2[1024];
   int data3[1024];
   int data4[1024];
   int data5[1024];
   int data6[1024];
   int data7[1024];
   int data8[1024];
   int data9[1024];
   int data10[1024];
   int data11[1024];
   int data12[1024];
   int data13[1024];
   int data14[1024];
   int data15[1024];
   int data16[1024];
   
   t.Branch("data1",  data1,  "data1[1024]/I" );
   t.Branch("data2",  data2,  "data2[1024]/I" );
   t.Branch("data3",  data3,  "data3[1024]/I" );
   t.Branch("data4",  data4,  "data4[1024]/I" );
   t.Branch("data5",  data5,  "data5[1024]/I" );
   t.Branch("data6",  data6,  "data6[1024]/I" );
   t.Branch("data7",  data7,  "data7[1024]/I" );
   t.Branch("data8",  data8,  "data8[1024]/I" );
   t.Branch("data9",  data9,  "data9[1024]/I" );
   t.Branch("data10", data10, "data10[1024]/I");
   t.Branch("data11", data11, "data11[1024]/I");
   t.Branch("data12", data12, "data12[1024]/I");
   t.Branch("data13", data13, "data13[1024]/I");
   t.Branch("data14", data14, "data14[1024]/I");
   t.Branch("data15", data15, "data15[1024]/I");
   t.Branch("data16", data16, "data16[1024]/I");
   
   int stop_num1;
   int stop_num2;
   
   t.Branch("stop_num1", &stop_num1, "stop_num1/I");
   t.Branch("stop_num2", &stop_num2, "stop_num2/I");
   
   int k;
   
   while (1) {
      totalread = 0;
      
      /* Magic Word Read */
      readnum   = fread(rawdata,1,4,fp);
      MagicWord = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      if (readnum==0) {
         break;
      } else if (readnum!=4) {
         fclose(fp);
         printf("Magic Word Read Error.\n");
         return -1;
      }
            
      totalread += readnum;
      
      /* TYPE Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      TYPE    = (((rawdata[totalread]&0xFF)<<16) + ((rawdata[totalread+1]&0xFF)<<8) + (rawdata[totalread+2]&0xFF));

      totalread += readnum;
      
      /* Length Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Length  = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Event ID Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      EventID = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Data Packet Read */
      hitnum = Length/2060;
      int cap_point;
      
      for (int i=0; i<hitnum; i++) {
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         DataType = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum   = fread(rawdata+totalread,1,2,fp);
         board_num = (rawdata[totalread]&0xFF);
         ch_num    = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         stop_ID = ((rawdata[totalread]&0xFC)>>2);
         stop_ch = (((rawdata[totalread]&0x03)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum     = fread(rawdata+totalread,1,2,fp);
         data_length = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,data_length,fp);


         if (ch_num==0) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch - 1024 ;
               } else {
                  cap_point = n + stop_ch        ;
               }
               data1[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==1) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch - 1024 ;
               } else {
                  cap_point = n + stop_ch        ;
               }
               data2[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==2) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data3[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==3) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data4[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==4) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data5[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==5) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data6[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==6) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data7[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==7) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data8[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==8) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data9[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==9) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data10[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==10) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data11[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==11) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data12[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==12) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data13[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==13) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data14[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==14) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data15[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==15) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data16[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         }
         
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         keyword = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         status   = (rawdata[totalread]&0xFF);
         checksum = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
         
         if (ch_num==7) {
            stop_num1 = stop_ch;
         } else if (ch_num==15) {
            stop_num2 = stop_ch;
         }  
      }
      
      t.Fill();
      
      /* Trailer Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Trailer = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      k = k + 1;
      if ((k%100)==0) {
         printf("%d times finished\n",k);
      }
   }
   
   fclose(fp);
   t.SetAlias("time","Iteration$");
   t.SetAlias("Eve","Entry$");
   
   char rootfile[32];
   sprintf(rootfile,"../Root_File/%s_correctped.root",run_number);
   
   TFile file(rootfile,"recreate");
   t.Write();
   file.Close();
}
