
void NoiseCheck(char *ped_number){

   gROOT->Reset();
   gStyle->SetOptFit(1);
   gStyle->SetOptStat(1);

   char filename[40];
   sprintf(filename,"../raw_data/%s.dat",ped_number);
   
   char filename2[40];
   sprintf(filename2,"../Root_File/%s_ped.root",ped_number);
   
   TFile f(filename2);
   
   double ch1_pedy[1024];
   double ch2_pedy[1024];
   double ch3_pedy[1024];
   double ch4_pedy[1024];
   double ch5_pedy[1024];
   double ch6_pedy[1024];
   double ch7_pedy[1024];
   double ch8_pedy[1024];
   double ch9_pedy[1024];
   double ch10_pedy[1024];
   double ch11_pedy[1024];
   double ch12_pedy[1024];
   double ch13_pedy[1024];
   double ch14_pedy[1024];
   double ch15_pedy[1024];
   double ch16_pedy[1024];
   
   for (int i=0; i<1024; i++) {
      ch1_pedy[i]  = ped_graph1->Eval(i,0,"");
      ch2_pedy[i]  = ped_graph2->Eval(i,0,"");
      ch3_pedy[i]  = ped_graph3->Eval(i,0,"");
      ch4_pedy[i]  = ped_graph4->Eval(i,0,"");
      ch5_pedy[i]  = ped_graph5->Eval(i,0,"");
      ch6_pedy[i]  = ped_graph6->Eval(i,0,"");
      ch7_pedy[i]  = ped_graph7->Eval(i,0,"");
      ch8_pedy[i]  = ped_graph8->Eval(i,0,"");
      ch9_pedy[i]  = ped_graph9->Eval(i,0,"");
      ch10_pedy[i] = ped_graph10->Eval(i,0,"");
      ch11_pedy[i] = ped_graph11->Eval(i,0,"");
      ch12_pedy[i] = ped_graph12->Eval(i,0,"");
      ch13_pedy[i] = ped_graph13->Eval(i,0,"");
      ch14_pedy[i] = ped_graph14->Eval(i,0,"");
      ch15_pedy[i] = ped_graph15->Eval(i,0,"");
      ch16_pedy[i] = ped_graph16->Eval(i,0,"");
      
      if (((i+1)%100)==0) {
         printf("%d times pedestal data read\n",i+1);
      }
   }
   
   f.Close();

   TH1F *NoiseHist1  = new TH1F("NoiseHist1", "NoiseHist1", 40,-5,5);
   TH1F *NoiseHist2  = new TH1F("NoiseHist2", "NoiseHist2", 40,-5,5);
   TH1F *NoiseHist3  = new TH1F("NoiseHist3", "NoiseHist3", 40,-5,5);
   TH1F *NoiseHist4  = new TH1F("NoiseHist4", "NoiseHist4", 40,-5,5);
   TH1F *NoiseHist5  = new TH1F("NoiseHist5", "NoiseHist5", 40,-5,5);
   TH1F *NoiseHist6  = new TH1F("NoiseHist6", "NoiseHist6", 40,-5,5);
   TH1F *NoiseHist7  = new TH1F("NoiseHist7", "NoiseHist7", 40,-5,5);
   TH1F *NoiseHist8  = new TH1F("NoiseHist8", "NoiseHist8", 40,-5,5);
   TH1F *NoiseHist9  = new TH1F("NoiseHist9", "NoiseHist9", 40,-5,5);
   TH1F *NoiseHist10 = new TH1F("NoiseHist10","NoiseHist10",40,-5,5);
   TH1F *NoiseHist11 = new TH1F("NoiseHist11","NoiseHist11",40,-5,5);
   TH1F *NoiseHist12 = new TH1F("NoiseHist12","NoiseHist12",40,-5,5);
   TH1F *NoiseHist13 = new TH1F("NoiseHist13","NoiseHist13",40,-5,5);
   TH1F *NoiseHist14 = new TH1F("NoiseHist14","NoiseHist14",40,-5,5);
   TH1F *NoiseHist15 = new TH1F("NoiseHist15","NoiseHist15",40,-5,5);
   TH1F *NoiseHist16 = new TH1F("NoiseHist16","NoiseHist16",40,-5,5);
   
   FILE *fp;
   if ((fp = fopen(filename,"rb+"))==NULL){
      printf("File open Error\n");
      return -1;
   }
      
   /*    */
   unsigned int  readnum;
   unsigned long long int totalread;
   unsigned char rawdata[33000];

   /*  Header/Footer Packet  */
   int MagicWord;
   int TYPE;
   unsigned int Length;
   unsigned int EventID;
   int Trailer;

   /*  Data Packet  */
   int hitnum;
   int DataType;
   int board_num;
   int ch_num;
   int stop_ID;
   int stop_ch;
   int data_length;
   int keyword;
   int status;
   int checksum;
   
   double data1[1024];
   double data2[1024];
   double data3[1024];
   double data4[1024];
   double data5[1024];
   double data6[1024];
   double data7[1024];
   double data8[1024];
   double data9[1024];
   double data10[1024];
   double data11[1024];
   double data12[1024];
   double data13[1024];
   double data14[1024];
   double data15[1024];
   double data16[1024];
   
   double dataline1  ;
   double dataline2  ;
   double dataline3  ;
   double dataline4  ;
   double dataline5  ;
   double dataline6  ;
   double dataline7  ;
   double dataline8  ;
   double dataline9  ;
   double dataline10 ;
   double dataline11 ;
   double dataline12 ;
   double dataline13 ;
   double dataline14 ;
   double dataline15 ;
   double dataline16 ;
   
   double alldata1  ;
   double alldata2  ;
   double alldata3  ;
   double alldata4  ;
   double alldata5  ;
   double alldata6  ;
   double alldata7  ;
   double alldata8  ;
   double alldata9  ;
   double alldata10 ;
   double alldata11 ;
   double alldata12 ;
   double alldata13 ;
   double alldata14 ;
   double alldata15 ;
   double alldata16 ;

   double tmp_data;
   
   int k;
   
   while (1) {
      totalread = 0;
      
      /* Magic Word Read */
      readnum   = fread(rawdata,1,4,fp);
      MagicWord = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      if (readnum==0) {
         break;
      } else if (readnum!=4) {
         fclose(fp);
         printf("Magic Word Read Error.\n");
         return -1;
      }
            
      totalread += readnum;
      
      /* TYPE Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      TYPE    = (((rawdata[totalread]&0xFF)<<16) + ((rawdata[totalread+1]&0xFF)<<8) + (rawdata[totalread+2]&0xFF));

      totalread += readnum;
      
      /* Length Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Length  = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Event ID Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      EventID = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Data Packet Read */
      hitnum = Length/2060;
      int cap_point;
      
      dataline1  = 0.0 ;
      dataline2  = 0.0 ;
      dataline3  = 0.0 ;
      dataline4  = 0.0 ;
      dataline5  = 0.0 ;
      dataline6  = 0.0 ;
      dataline7  = 0.0 ;
      dataline8  = 0.0 ;
      dataline9  = 0.0 ;
      dataline10 = 0.0 ;
      dataline11 = 0.0 ;
      dataline12 = 0.0 ;
      dataline13 = 0.0 ;
      dataline14 = 0.0 ;
      dataline15 = 0.0 ;
      dataline16 = 0.0 ;
      
      alldata1   = 0.0 ;
      alldata2   = 0.0 ;
      alldata3   = 0.0 ;
      alldata4   = 0.0 ;
      alldata5   = 0.0 ;
      alldata6   = 0.0 ;
      alldata7   = 0.0 ;
      alldata8   = 0.0 ;
      alldata9   = 0.0 ;
      alldata10  = 0.0 ;
      alldata11  = 0.0 ;
      alldata12  = 0.0 ;
      alldata13  = 0.0 ;
      alldata14  = 0.0 ;
      alldata15  = 0.0 ;
      alldata16  = 0.0 ;
      
      for (int i=0; i<hitnum; i++) {
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         DataType = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum   = fread(rawdata+totalread,1,2,fp);
         board_num = (rawdata[totalread]&0xFF);
         ch_num    = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         stop_ID = ((rawdata[totalread]&0xFC)>>2);
         stop_ch = (((rawdata[totalread]&0x03)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum     = fread(rawdata+totalread,1,2,fp);
         data_length = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,data_length,fp);
         
         if (ch_num==0) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data1[n] = (tmp_data - ch1_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata1 = alldata1 + data1[n] ;
            }
         } else if (ch_num==1) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data2[n] = (tmp_data - ch2_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata2 = alldata2 + data2[n] ;
            }
         } else if (ch_num==2) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data3[n] = (tmp_data - ch3_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata3 = alldata3 + data3[n] ;
            }
         } else if (ch_num==3) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data4[n] = (tmp_data - ch4_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata4 = alldata4 + data4[n] ;
            }
         } else if (ch_num==4) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data5[n] = (tmp_data - ch5_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata5 = alldata5 + data5[n] ;
            }
         } else if (ch_num==5) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data6[n] = (tmp_data - ch6_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata6 = alldata6 + data6[n] ;
            }
         } else if (ch_num==6) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data7[n] = (tmp_data - ch7_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata7 = alldata7 + data7[n] ;
            }
         } else if (ch_num==7) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data8[n] = (tmp_data - ch8_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata8 = alldata8 + data8[n] ;
            }
         } else if (ch_num==8) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data9[n] = (tmp_data - ch9_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata9 = alldata9 + data9[n] ;
            }
         } else if (ch_num==9) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data  = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data10[n] = (tmp_data - ch10_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata10 = alldata10 + data10[n] ;
            }
         } else if (ch_num==10) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data  = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data11[n] = (tmp_data - ch11_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata11 = alldata11 + data11[n] ;
            }
         } else if (ch_num==11) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data  = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data12[n] = (tmp_data - ch12_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata12 = alldata12 + data12[n] ;
            }
         } else if (ch_num==12) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data  = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data13[n] = (tmp_data - ch13_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata13 = alldata13 + data13[n] ;
            }
         } else if (ch_num==13) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data  = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data14[n] = (tmp_data - ch14_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata14 = alldata14 + data14[n] ;
            }
         } else if (ch_num==14) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data  = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data15[n] = (tmp_data - ch15_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata15 = alldata15 + data15[n] ;
            }
         } else if (ch_num==15) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data  = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data16[n] = (tmp_data - ch16_pedy[cap_point]) * (1000.0 / 4096.0);
               alldata16 = alldata16 + data16[n] ;
            }
         }
         
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         keyword = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         status   = (rawdata[totalread]&0xFF);
         checksum = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
      }
      
      dataline1  = alldata1  / 1024.0 ;
      dataline2  = alldata2  / 1024.0 ;
      dataline3  = alldata3  / 1024.0 ;
      dataline4  = alldata4  / 1024.0 ;
      dataline5  = alldata5  / 1024.0 ;
      dataline6  = alldata6  / 1024.0 ;
      dataline7  = alldata7  / 1024.0 ;
      dataline8  = alldata8  / 1024.0 ;
      dataline9  = alldata9  / 1024.0 ;
      dataline10 = alldata10 / 1024.0 ;
      dataline11 = alldata11 / 1024.0 ;
      dataline12 = alldata12 / 1024.0 ;
      dataline13 = alldata13 / 1024.0 ;
      dataline14 = alldata14 / 1024.0 ;
      dataline15 = alldata15 / 1024.0 ;
      dataline16 = alldata16 / 1024.0 ;
      
      for (int j=0; j<1024; j++) {
         NoiseHist1->Fill(data1[j]-dataline1);
         NoiseHist2->Fill(data2[j]-dataline2);
         NoiseHist3->Fill(data3[j]-dataline3);
         NoiseHist4->Fill(data4[j]-dataline4);
         NoiseHist5->Fill(data5[j]-dataline5);
         NoiseHist6->Fill(data6[j]-dataline6);
         NoiseHist7->Fill(data7[j]-dataline7);
         NoiseHist8->Fill(data8[j]-dataline8);
         NoiseHist9->Fill(data9[j]-dataline9);
         NoiseHist10->Fill(data10[j]-dataline10);
         NoiseHist11->Fill(data11[j]-dataline11);
         NoiseHist12->Fill(data12[j]-dataline12);
         NoiseHist13->Fill(data13[j]-dataline13);
         NoiseHist14->Fill(data14[j]-dataline14);
         NoiseHist15->Fill(data15[j]-dataline15);
         NoiseHist16->Fill(data16[j]-dataline16);
      }
      
      /* Trailer Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Trailer = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      k = k + 1;
      if ((k%100)==0) {
         printf("%d times finished\n",k);
      }
      
   }
   
   fclose(fp);
   
// NoiseHist1->Fit("gaus","","",-1.5,1.5);
   NoiseHist1->Fit("gaus");
   NoiseHist2->Fit("gaus");
   NoiseHist3->Fit("gaus");
   NoiseHist4->Fit("gaus");
   NoiseHist5->Fit("gaus");
   NoiseHist6->Fit("gaus");
   NoiseHist7->Fit("gaus");
   NoiseHist8->Fit("gaus");
   NoiseHist9->Fit("gaus");
   NoiseHist10->Fit("gaus");
   NoiseHist11->Fit("gaus");
   NoiseHist12->Fit("gaus");
   NoiseHist13->Fit("gaus");
   NoiseHist14->Fit("gaus");
   NoiseHist15->Fit("gaus");
   NoiseHist16->Fit("gaus");
   
   char rootfile[32];
   sprintf(rootfile,"../Root_File/%s_noise.root",ped_number);
   
   TFile file(rootfile,"recreate");
   
   NoiseHist1->Write("NoiseHist1");
   NoiseHist2->Write("NoiseHist2");
   NoiseHist3->Write("NoiseHist3");
   NoiseHist4->Write("NoiseHist4");
   NoiseHist5->Write("NoiseHist5");
   NoiseHist6->Write("NoiseHist6");
   NoiseHist7->Write("NoiseHist7");
   NoiseHist8->Write("NoiseHist8");
   NoiseHist9->Write("NoiseHist9");
   NoiseHist10->Write("NoiseHist10");
   NoiseHist11->Write("NoiseHist11");
   NoiseHist12->Write("NoiseHist12");
   NoiseHist13->Write("NoiseHist13");
   NoiseHist14->Write("NoiseHist14");
   NoiseHist15->Write("NoiseHist15");
   NoiseHist16->Write("NoiseHist16");
   
   file.Close();
}
