
void DecibelCheck(char* fname1, int fit_ch)
{
   double Min_Mean1[16];
   double Min_RMS1[16];
   double Max_Mean1[16];
   double Max_RMS1[16];

   FILE *fp1 = fopen(fname1,"r+");
   char line[256];
   int j=0;

   while(fgets(line,sizeof(line),fp1)) {
      if (j==0) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Min_Mean1[0], &Min_Mean1[1], &Min_Mean1[2],  &Min_Mean1[3],  &Min_Mean1[4],  &Min_Mean1[5],  &Min_Mean1[6],  &Min_Mean1[7]);
      } else if (j==1) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Min_RMS1[0],  &Min_RMS1[1],  &Min_RMS1[2],   &Min_RMS1[3],   &Min_RMS1[4],   &Min_RMS1[5],   &Min_RMS1[6],   &Min_RMS1[7]);
      } else if (j==2) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Min_Mean1[8], &Min_Mean1[9], &Min_Mean1[10], &Min_Mean1[11], &Min_Mean1[12], &Min_Mean1[13], &Min_Mean1[14], &Min_Mean1[15]);
      } else if (j==3) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Min_RMS1[8],  &Min_RMS1[9],  &Min_RMS1[10],  &Min_RMS1[11],  &Min_RMS1[12],  &Min_RMS1[13],  &Min_RMS1[14],  &Min_RMS1[15]);
      } else if (j==4) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Max_Mean1[0], &Max_Mean1[1], &Max_Mean1[2],  &Max_Mean1[3],  &Max_Mean1[4],  &Max_Mean1[5],  &Max_Mean1[6],  &Max_Mean1[7]);
      } else if (j==5) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Max_RMS1[0],  &Max_RMS1[1],  &Max_RMS1[2],   &Max_RMS1[3],   &Max_RMS1[4],   &Max_RMS1[5],   &Max_RMS1[6],   &Max_RMS1[7]);
      } else if (j==6) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Max_Mean1[8], &Max_Mean1[9], &Max_Mean1[10], &Max_Mean1[11], &Max_Mean1[12], &Max_Mean1[13], &Max_Mean1[14], &Max_Mean1[15]);
      } else if (j==7) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Max_RMS1[8],  &Max_RMS1[9],  &Max_RMS1[10],  &Max_RMS1[11],  &Max_RMS1[12],  &Max_RMS1[13],  &Max_RMS1[14],  &Max_RMS1[15]);
      }
      j++;
   }

   fclose(fp1);

   for (int i=0; i<16; i++) {
      Min_RMS1[i] = (double)(Min_RMS1[i] / sqrt(1000.0)) ;
      Max_RMS1[i] = (double)(Max_RMS1[i] / sqrt(1000.0)) ;
   }
   
   double base_value;
   double base_error;
   
   if (fit_ch==1) {
      base_value = Min_Mean1[0];
      base_error = Min_RMS1[0];
   } else if (fit_ch==3) {
      base_value = Min_Mean1[2];
      base_error = Min_RMS1[2];
   } else if (fit_ch==4) {
      base_value = Min_Mean1[3];
      base_error = Min_RMS1[3];
   } else if (fit_ch==5) {
      base_value = Min_Mean1[4];
      base_error = Min_RMS1[4];
   } else if (fit_ch==6) {
      base_value = Min_Mean1[5];
      base_error = Min_RMS1[5];
   } else if (fit_ch==7) {
      base_value = Min_Mean1[6];
      base_error = Min_RMS1[6];
   } else if (fit_ch==8) {
      base_value = Min_Mean1[7];
      base_error = Min_RMS1[7];
   } else if (fit_ch==10) {
      base_value = Min_Mean1[9];
      base_error = Min_RMS1[9];
   } else if (fit_ch==11) {
      base_value = Min_Mean1[10];
      base_error = Min_RMS1[10];
   } else if (fit_ch==12) {
      base_value = Min_Mean1[11];
      base_error = Min_RMS1[11];
   } else if (fit_ch==13) {
      base_value = Min_Mean1[12];
      base_error = Min_RMS1[12];
   } else if (fit_ch==14) {
      base_value = Min_Mean1[13];
      base_error = Min_RMS1[13];
   } else if (fit_ch==15) {
      base_value = Min_Mean1[14];
      base_error = Min_RMS1[14];
   } else if (fit_ch==16) {
      base_value = Min_Mean1[15];
      base_error = Min_RMS1[15];
   }

   double dB[16];
   double ch[16];
   double dBe[16];
   double che[16];
   
   for (int i=0; i<16; i++) {
      dB[i]  = 10.0 * log10(Min_Mean1[i]/base_value);
      dBe[i] = sqrt(100*((base_error/(base_value*log(10.0)))*(base_error/(base_value*log(10.0))) + (Min_RMS1[i]/(Min_Mean1[i]*log(10.0)))*(Min_RMS1[i]/(Min_Mean1[i]*log(10.0)))));
      ch[i]  = (double)(i+1);
      che[i] = 0.0;
   }

// TGraph *gr1 = new TGraph(16,ch,dB);
   TGraphErrors *gr1 = new TGraphErrors(16,ch,dB,che,dBe);
   
   TCanvas *c6 = new TCanvas("c6","c6",800,600);
   c6->SetGrid();

   gr1->SetMarkerColor(2);
   gr1->SetLineColor(2);
   gr1->SetTitle("Decibel Check");
   gr1->GetXaxis()->SetTitle("ch");
   gr1->GetYaxis()->SetTitle("dB");
   gr1->Draw("A*");

}
