
void WaveCheck(char *run_number,char *ped_number){

   gROOT->Reset();

   char filename[40];
   sprintf(filename,"../raw_data/%s.dat",run_number);
   
   char filename2[40];
   sprintf(filename2,"../Root_File/%s_ped.root",ped_number);
   
   TFile f(filename2);
   
   double ch1_pedy[1024];
   double ch2_pedy[1024];
   double ch3_pedy[1024];
   double ch4_pedy[1024];
   double ch5_pedy[1024];
   double ch6_pedy[1024];
   double ch7_pedy[1024];
   double ch8_pedy[1024];
   double ch9_pedy[1024];
   double ch10_pedy[1024];
   double ch11_pedy[1024];
   double ch12_pedy[1024];
   double ch13_pedy[1024];
   double ch14_pedy[1024];
   double ch15_pedy[1024];
   double ch16_pedy[1024];
   
   for (int i=0; i<1024; i++) {
      ch1_pedy[i]  = ped_graph1->Eval(i,0,"");
      ch2_pedy[i]  = ped_graph2->Eval(i,0,"");
      ch3_pedy[i]  = ped_graph3->Eval(i,0,"");
      ch4_pedy[i]  = ped_graph4->Eval(i,0,"");
      ch5_pedy[i]  = ped_graph5->Eval(i,0,"");
      ch6_pedy[i]  = ped_graph6->Eval(i,0,"");
      ch7_pedy[i]  = ped_graph7->Eval(i,0,"");
      ch8_pedy[i]  = ped_graph8->Eval(i,0,"");
      ch9_pedy[i]  = ped_graph9->Eval(i,0,"");
      ch10_pedy[i] = ped_graph10->Eval(i,0,"");
      ch11_pedy[i] = ped_graph11->Eval(i,0,"");
      ch12_pedy[i] = ped_graph12->Eval(i,0,"");
      ch13_pedy[i] = ped_graph13->Eval(i,0,"");
      ch14_pedy[i] = ped_graph14->Eval(i,0,"");
      ch15_pedy[i] = ped_graph15->Eval(i,0,"");
      ch16_pedy[i] = ped_graph16->Eval(i,0,"");
      
      if (((i+1)%100)==0) {
         printf("%d times pedestal data read\n",i);
      }
   }
      
   f.Close();
   
   FILE *fp;
   if ((fp = fopen(filename,"rb+"))==NULL){
      printf("File open Error\n");
      return -1;
   }
   
   TTree t("t","t");
   
   /*    */
   unsigned int  readnum;
   unsigned long long int totalread;
   unsigned char rawdata[33000];

   /*  Header/Footer Packet  */
   int MagicWord;
   int TYPE;
   unsigned int Length;
   unsigned int EventID;
   int Trailer;

   /*  Data Packet  */
   int hitnum;
   int DataType;
   int board_num;
   int ch_num;
   int stop_ID;
   int stop_ch;
   int data_length;
   int keyword;
   int status;
   int checksum;
   
   double data1[1024];
   double data2[1024];
   double data3[1024];
   double data4[1024];
   double data5[1024];
   double data6[1024];
   double data7[1024];
   double data8[1024];
   double data9[1024];
   double data10[1024];
   double data11[1024];
   double data12[1024];
   double data13[1024];
   double data14[1024];
   double data15[1024];
   double data16[1024];
   
   t.Branch("data1",  data1,  "data1[1024]/D" );
   t.Branch("data2",  data2,  "data2[1024]/D" );
   t.Branch("data3",  data3,  "data3[1024]/D" );
   t.Branch("data4",  data4,  "data4[1024]/D" );
   t.Branch("data5",  data5,  "data5[1024]/D" );
   t.Branch("data6",  data6,  "data6[1024]/D" );
   t.Branch("data7",  data7,  "data7[1024]/D" );
   t.Branch("data8",  data8,  "data8[1024]/D" );
   t.Branch("data9",  data9,  "data9[1024]/D" );
   t.Branch("data10", data10, "data10[1024]/D");
   t.Branch("data11", data11, "data11[1024]/D");
   t.Branch("data12", data12, "data12[1024]/D");
   t.Branch("data13", data13, "data13[1024]/D");
   t.Branch("data14", data14, "data14[1024]/D");
   t.Branch("data15", data15, "data15[1024]/D");
   t.Branch("data16", data16, "data16[1024]/D");
   
   Int_t stop_num1;
   Int_t stop_num2;
   
   t.Branch("stop_num1", &stop_num1, "stop_num1/I_t");
   t.Branch("stop_num2", &stop_num2, "stop_num2/I_t");

   Double_t tmp_data;
   Double_t time[1024];
   
   t.Branch("time", time, "time[1024]/D_t");

   Double_t d_i;
   d_i = 0.0;

   for (int i=0; i<1024; i++) {
      time[i] = (d_i * 1000.0) / 1024.0 ;
      d_i     = d_i + 1.0;
   }
   
   int k;
   
   while (1) {
      totalread = 0;
      
      /* Magic Word Read */
      readnum   = fread(rawdata,1,4,fp);
      MagicWord = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      if (readnum==0) {
         break;
      } else if (readnum!=4) {
         fclose(fp);
         printf("Magic Word Read Error.\n");
         return -1;
      }
      
      totalread += readnum;
      
      /* TYPE Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      TYPE    = (((rawdata[totalread]&0xFF)<<16) + ((rawdata[totalread+1]&0xFF)<<8) + (rawdata[totalread+2]&0xFF));

      totalread += readnum;
      
      /* Length Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Length  = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Event ID Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      EventID = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Data Packet Read */
      hitnum = Length/2060;
      int cap_point;
      
      for (int i=0; i<hitnum; i++) {
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         DataType = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum   = fread(rawdata+totalread,1,2,fp);
         board_num = (rawdata[totalread]&0xFF);
         ch_num    = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         stop_ID = ((rawdata[totalread]&0xFC)>>2);
         stop_ch = (((rawdata[totalread]&0x03)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum     = fread(rawdata+totalread,1,2,fp);
         data_length = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,data_length,fp);


         if (ch_num==0) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data1[n] = (tmp_data - ch1_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         } else if (ch_num==1) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data2[n] = (tmp_data - ch2_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         } else if (ch_num==2) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data3[n] = (tmp_data - ch3_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         } else if (ch_num==3) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data4[n] = (tmp_data - ch4_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         } else if (ch_num==4) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data5[n] = (tmp_data - ch5_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         } else if (ch_num==5) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data6[n] = (tmp_data - ch6_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         } else if (ch_num==6) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data7[n] = (tmp_data - ch7_pedy[cap_point]) * (1000.0 / 4096.0) / 0.985;
            }
         } else if (ch_num==7) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data8[n] = (tmp_data - ch8_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         } else if (ch_num==8) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data9[n] = (tmp_data - ch9_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         } else if (ch_num==9) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data10[n] = (tmp_data - ch10_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         } else if (ch_num==10) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data11[n] = (tmp_data - ch11_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         } else if (ch_num==11) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data12[n] = (tmp_data - ch12_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         } else if (ch_num==12) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data13[n] = (tmp_data - ch13_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         } else if (ch_num==13) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data14[n] = (tmp_data - ch14_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         } else if (ch_num==14) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data15[n] = (tmp_data - ch15_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         } else if (ch_num==15) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data16[n] = (tmp_data - ch16_pedy[cap_point]) * (1000.0 / 4096.0);
            }
         }
         
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         keyword = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         status   = (rawdata[totalread]&0xFF);
         checksum = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
         
         if (ch_num==7) {
            stop_num1 = stop_ch;
         } else if (ch_num==15) {
            stop_num2 = stop_ch;
         }  
      }
      
      t.Fill();
      
      /* Trailer Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Trailer = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      k = k + 1;
      if ((k%100)==0) {
         printf("%d times finished\n",k);
      }
   }
   
   fclose(fp);
   
   char rootfile[32];
   sprintf(rootfile,"../Root_File/%s_wave.root",run_number);
   
   TFile file(rootfile,"recreate");
   t.Write();
   file.Close();
}
