
void PeakPoint(char *run_number,char *ped_number){

   gROOT->Reset();

   char filename[40];
   sprintf(filename,"../raw_data/%s.dat",run_number);
   
   char filename2[40];
   sprintf(filename2,"../Root_File/%s_ped.root",ped_number);
   
   TFile f(filename2);
   
   double ch1_pedy[1024];
   double ch2_pedy[1024];
   double ch3_pedy[1024];
   double ch4_pedy[1024];
   double ch5_pedy[1024];
   double ch6_pedy[1024];
   double ch7_pedy[1024];
   double ch8_pedy[1024];
   double ch9_pedy[1024];
   double ch10_pedy[1024];
   double ch11_pedy[1024];
   double ch12_pedy[1024];
   double ch13_pedy[1024];
   double ch14_pedy[1024];
   double ch15_pedy[1024];
   double ch16_pedy[1024];
   
   for (int i=0; i<1024; i++) {
      ch1_pedy[i]  = ped_graph1->Eval(i,0,"");
      ch2_pedy[i]  = ped_graph2->Eval(i,0,"");
      ch3_pedy[i]  = ped_graph3->Eval(i,0,"");
      ch4_pedy[i]  = ped_graph4->Eval(i,0,"");
      ch5_pedy[i]  = ped_graph5->Eval(i,0,"");
      ch6_pedy[i]  = ped_graph6->Eval(i,0,"");
      ch7_pedy[i]  = ped_graph7->Eval(i,0,"");
      ch8_pedy[i]  = ped_graph8->Eval(i,0,"");
      ch9_pedy[i]  = ped_graph9->Eval(i,0,"");
      ch10_pedy[i] = ped_graph10->Eval(i,0,"");
      ch11_pedy[i] = ped_graph11->Eval(i,0,"");
      ch12_pedy[i] = ped_graph12->Eval(i,0,"");
      ch13_pedy[i] = ped_graph13->Eval(i,0,"");
      ch14_pedy[i] = ped_graph14->Eval(i,0,"");
      ch15_pedy[i] = ped_graph15->Eval(i,0,"");
      ch16_pedy[i] = ped_graph16->Eval(i,0,"");
      
      if (((i+1)%100)==0) {
         printf("%d times pedestal data read\n",i);
      }
   }
   
   f.Close();
   
   TH1F *PeakHist1  = new TH1F("PeakHist1", "PeakHist1", 2000,-1000,0);
   TH1F *PeakHist2  = new TH1F("PeakHist2", "PeakHist2", 2000,-1000,0);
   TH1F *PeakHist3  = new TH1F("PeakHist3", "PeakHist3", 2000,-1000,0);
   TH1F *PeakHist4  = new TH1F("PeakHist4", "PeakHist4", 2000,-1000,0);
   TH1F *PeakHist5  = new TH1F("PeakHist5", "PeakHist5", 2000,-1000,0);
   TH1F *PeakHist6  = new TH1F("PeakHist6", "PeakHist6", 2000,-1000,0);
   TH1F *PeakHist7  = new TH1F("PeakHist7", "PeakHist7", 2000,-1000,0);
   TH1F *PeakHist8  = new TH1F("PeakHist8", "PeakHist8", 2000,-1000,0);
   TH1F *PeakHist9  = new TH1F("PeakHist9", "PeakHist9", 2000,-1000,0);
   TH1F *PeakHist10 = new TH1F("PeakHist10","PeakHist10",2000,-1000,0);
   TH1F *PeakHist11 = new TH1F("PeakHist11","PeakHist11",2000,-1000,0);
   TH1F *PeakHist12 = new TH1F("PeakHist12","PeakHist12",2000,-1000,0);
   TH1F *PeakHist13 = new TH1F("PeakHist13","PeakHist13",2000,-1000,0);
   TH1F *PeakHist14 = new TH1F("PeakHist14","PeakHist14",2000,-1000,0);
   TH1F *PeakHist15 = new TH1F("PeakHist15","PeakHist15",2000,-1000,0);
   TH1F *PeakHist16 = new TH1F("PeakHist16","PeakHist16",2000,-1000,0);
   
   FILE *fp;
   if ((fp = fopen(filename,"rb+"))==NULL){
      printf("File open Error\n");
      return -1;
   }
   
   /*    */
   unsigned int  readnum;
   unsigned long long int totalread;
   unsigned char rawdata[33000];

   /*  Header/Footer Packet  */
   int MagicWord;
   int TYPE;
   unsigned int Length;
   unsigned int EventID;
   int Trailer;

   /*  Data Packet  */
   int hitnum;
   int DataType;
   int board_num;
   int ch_num;
   int stop_ID;
   int stop_ch;
   int data_length;
   int keyword;
   int status;
   int checksum;
   
   double data1[1024];
   double data2[1024];
   double data3[1024];
   double data4[1024];
   double data5[1024];
   double data6[1024];
   double data7[1024];
   double data8[1024];
   double data9[1024];
   double data10[1024];
   double data11[1024];
   double data12[1024];
   double data13[1024];
   double data14[1024];
   double data15[1024];
   double data16[1024];
   
   double alldata1;
   double alldata2;
   double alldata3;
   double alldata4;
   double alldata5;
   double alldata6;
   double alldata7;
   double alldata8;
   double alldata9;
   double alldata10;
   double alldata11;
   double alldata12;
   double alldata13;
   double alldata14;
   double alldata15;
   double alldata16;
   
   double dataline1;
   double dataline2;
   double dataline3;
   double dataline4;
   double dataline5;
   double dataline6;
   double dataline7;
   double dataline8;
   double dataline9;
   double dataline10;
   double dataline11;
   double dataline12;
   double dataline13;
   double dataline14;
   double dataline15;
   double dataline16;

   double peakdata1;
   double peakdata2;
   double peakdata3;
   double peakdata4;
   double peakdata5;
   double peakdata6;
   double peakdata7;
   double peakdata8;
   double peakdata9;
   double peakdata10;
   double peakdata11;
   double peakdata12;
   double peakdata13;
   double peakdata14;
   double peakdata15;
   double peakdata16;

   double pre_data;
   double aft_data;
   
   int k;
   
   while (1) {
      totalread = 0;
      
      /* Magic Word Read */
      readnum   = fread(rawdata,1,4,fp);
      MagicWord = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      if (readnum==0) {
         break;
      } else if (readnum!=4) {
         fclose(fp);
         printf("Magic Word Read Error.\n");
         return -1;
      }
            
      totalread += readnum;
      
      /* TYPE Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      TYPE    = (((rawdata[totalread]&0xFF)<<16) + ((rawdata[totalread+1]&0xFF)<<8) + (rawdata[totalread+2]&0xFF));

      totalread += readnum;
      
      /* Length Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Length  = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Event ID Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      EventID = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Data Packet Read */
      hitnum = Length/2060;
      int cap_point;
      
      for (int i=0; i<hitnum; i++) {
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         DataType = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum   = fread(rawdata+totalread,1,2,fp);
         board_num = (rawdata[totalread]&0xFF);
         ch_num    = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         stop_ID = ((rawdata[totalread]&0xFC)>>2);
         stop_ch = (((rawdata[totalread]&0x03)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum     = fread(rawdata+totalread,1,2,fp);
         data_length = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,data_length,fp);


         if (ch_num==0) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data1[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch1_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         } else if (ch_num==1) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data2[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch2_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         } else if (ch_num==2) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data3[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch3_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         } else if (ch_num==3) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data4[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch4_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         } else if (ch_num==4) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data5[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch5_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         } else if (ch_num==5) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data6[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch6_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         } else if (ch_num==6) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data7[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch7_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         } else if (ch_num==7) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data8[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch8_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         } else if (ch_num==8) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data9[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch9_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         } else if (ch_num==9) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data10[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch10_pedy[cap_point]) * (1000.0/4096.0);
            }
         } else if (ch_num==10) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data11[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch11_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         } else if (ch_num==11) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data12[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch12_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         } else if (ch_num==12) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data13[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch13_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         } else if (ch_num==13) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data14[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch14_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         } else if (ch_num==14) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data15[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch15_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         } else if (ch_num==15) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               data16[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch16_pedy[cap_point]) * (1000.0/4096.0) ;
            }
         }
         
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         keyword = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         status   = (rawdata[totalread]&0xFF);
         checksum = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
      }
      
      alldata1  = 0.0 ;
      alldata2  = 0.0 ;
      alldata3  = 0.0 ;
      alldata4  = 0.0 ;
      alldata5  = 0.0 ;
      alldata6  = 0.0 ;
      alldata7  = 0.0 ;
      alldata8  = 0.0 ;
      alldata9  = 0.0 ;
      alldata10 = 0.0 ;
      alldata11 = 0.0 ;
      alldata12 = 0.0 ;
      alldata13 = 0.0 ;
      alldata14 = 0.0 ;
      alldata15 = 0.0 ;
      alldata16 = 0.0 ;
      
      for (int i=10; i<510; i++) {
         alldata1  = alldata1  + data1[i]  ;
         alldata2  = alldata2  + data2[i]  ;
         alldata3  = alldata3  + data3[i]  ;
         alldata4  = alldata4  + data4[i]  ;
         alldata5  = alldata5  + data5[i]  ;
         alldata6  = alldata6  + data6[i]  ;
         alldata7  = alldata7  + data7[i]  ;
         alldata8  = alldata8  + data8[i]  ;
         alldata9  = alldata9  + data9[i]  ;
         alldata10 = alldata10 + data10[i] ;
         alldata11 = alldata11 + data11[i] ;
         alldata12 = alldata12 + data12[i] ;
         alldata13 = alldata13 + data13[i] ;
         alldata14 = alldata14 + data14[i] ;
         alldata15 = alldata15 + data15[i] ;
         alldata16 = alldata16 + data16[i] ;
      }
      
      dataline1  = alldata1  / 500.0 ;
      dataline2  = alldata2  / 500.0 ;
      dataline3  = alldata3  / 500.0 ;
      dataline4  = alldata4  / 500.0 ;
      dataline5  = alldata5  / 500.0 ;
      dataline6  = alldata6  / 500.0 ;
      dataline7  = alldata7  / 500.0 ;
      dataline8  = alldata8  / 500.0 ;
      dataline9  = alldata9  / 500.0 ;
      dataline10 = alldata10 / 500.0 ;
      dataline11 = alldata11 / 500.0 ;
      dataline12 = alldata12 / 500.0 ;
      dataline13 = alldata13 / 500.0 ;
      dataline14 = alldata14 / 500.0 ;
      dataline15 = alldata15 / 500.0 ;
      dataline16 = alldata16 / 500.0 ;

      peakdata1  = data1[500];
      peakdata2  = data2[500];
      peakdata3  = data3[500];
      peakdata4  = data4[500];
      peakdata5  = data5[500];
      peakdata6  = data6[500];
      peakdata7  = data7[500];
      peakdata8  = data8[500];
      peakdata9  = data9[500];
      peakdata10 = data10[500];
      peakdata11 = data11[500];
      peakdata12 = data12[500];
      peakdata13 = data13[500];
      peakdata14 = data14[500];
      peakdata15 = data15[500];
      peakdata16 = data16[500];
      
      for (int i=501; i<1024; i++) {
         if (peakdata1>data1[i]) {
            peakdata1 = data1[i];
         }
         if (peakdata2 > data2[i]) {
            peakdata2 = data2[i];
         }
         if (peakdata3 > data3[i]) {
            peakdata3 = data3[i];
         }
         if (peakdata4 > data4[i]) {
            peakdata4 = data4[i];
         }
         if (peakdata5 > data5[i]) {
            peakdata5 = data5[i];
         }
         if (peakdata6 > data6[i]) {
            peakdata6 = data6[i];
         }
         if (peakdata7 > data7[i]) {
            peakdata7 = data7[i];
         }
         if (peakdata8 > data8[i]) {
            peakdata8 = data8[i];
         }
         if (peakdata9 > data9[i]) {
            peakdata9 = data9[i];
         }
         if (peakdata10 > data10[i]) {
            peakdata10 = data10[i];
         }
         if (peakdata11 > data11[i]) {
            peakdata11 = data11[i];
         }
         if (peakdata12 > data12[i]) {
            peakdata12 = data12[i];
         }
         if (peakdata13 > data13[i]) {
            peakdata13 = data13[i];
         }
         if (peakdata14 > data14[i]) {
            peakdata14 = data14[i];
         }
         if (peakdata15 > data15[i]) {
            peakdata15 = data15[i];
         }
         if (peakdata16 > data16[i]) {
            peakdata16 = data16[i];
         }
      }
      
      PeakHist1->Fill(peakdata1-dataline1);
      PeakHist2->Fill(peakdata2-dataline2);
      PeakHist3->Fill(peakdata3-dataline3);
      PeakHist4->Fill(peakdata4-dataline4);
      PeakHist5->Fill(peakdata5-dataline5);
      PeakHist6->Fill(peakdata6-dataline6);
      PeakHist7->Fill(peakdata7-dataline7);
      PeakHist8->Fill(peakdata8-dataline8);
      PeakHist9->Fill(peakdata9-dataline9);
      PeakHist10->Fill(peakdata10-dataline10);
      PeakHist11->Fill(peakdata11-dataline11);
      PeakHist12->Fill(peakdata12-dataline12);
      PeakHist13->Fill(peakdata13-dataline13);
      PeakHist14->Fill(peakdata14-dataline14);
      PeakHist15->Fill(peakdata15-dataline15);
      PeakHist16->Fill(peakdata16-dataline16);
      
      /* Trailer Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Trailer = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      k = k + 1;
      if ((k%100)==0) {
         printf("%d times finished\n",k);
      }
   }
   
   fclose(fp);
   
   gStyle->SetOptFit();
   
   PeakHist1->Fit("gaus");
   PeakHist2->Fit("gaus");
   PeakHist3->Fit("gaus");
   PeakHist4->Fit("gaus");
   PeakHist5->Fit("gaus");
   PeakHist6->Fit("gaus");
   PeakHist7->Fit("gaus");
   PeakHist8->Fit("gaus");
   PeakHist9->Fit("gaus");
   PeakHist10->Fit("gaus");
   PeakHist11->Fit("gaus");
   PeakHist12->Fit("gaus");
   PeakHist13->Fit("gaus");
   PeakHist14->Fit("gaus");
   PeakHist15->Fit("gaus");
   PeakHist16->Fit("gaus");

   TCanvas *c1 = new TCanvas("c1","c1",1400,800);
   c1->Divide(4,2);

   TCanvas *c2 = new TCanvas("c2","c2",1400,800);
   c2->Divide(4,2);

   c1->cd(1);
   PeakHist1->Draw();

   c1->cd(2);
   PeakHist2->Draw();

   c1->cd(3);
   PeakHist3->Draw();

   c1->cd(4);
   PeakHist4->Draw();

   c1->cd(5);
   PeakHist5->Draw();

   c1->cd(6);
   PeakHist6->Draw();

   c1->cd(7);
   PeakHist7->Draw();

   c1->cd(8);
   PeakHist8->Draw();




   c2->cd(1);
   PeakHist9->Draw();

   c2->cd(2);
   PeakHist10->Draw();

   c2->cd(3);
   PeakHist11->Draw();

   c2->cd(4);
   PeakHist12->Draw();

   c2->cd(5);
   PeakHist13->Draw();

   c2->cd(6);
   PeakHist14->Draw();

   c2->cd(7);
   PeakHist15->Draw();

   c2->cd(8);
   PeakHist16->Draw();













   
   char rootfile[32];
   sprintf(rootfile,"../Root_File/%s_peak.root",run_number);
   
   TFile file(rootfile,"recreate");
   
   PeakHist1->Write("PeakHist1");
   PeakHist2->Write("PeakHist2");
   PeakHist3->Write("PeakHist3");
   PeakHist4->Write("PeakHist4");
   PeakHist5->Write("PeakHist5");
   PeakHist6->Write("PeakHist6");
   PeakHist7->Write("PeakHist7");
   PeakHist8->Write("PeakHist8");
   PeakHist9->Write("PeakHist9");
   PeakHist10->Write("PeakHist10");
   PeakHist11->Write("PeakHist11");
   PeakHist12->Write("PeakHist12");
   PeakHist13->Write("PeakHist13");
   PeakHist14->Write("PeakHist14");
   PeakHist15->Write("PeakHist15");
   PeakHist16->Write("PeakHist16");
   
   file.Close();
}
