
#include <stdio.h>

int main(int argc, char *argv[]){

   if (argc!=3) {
      printf("Usage : %s <Run Number> <Chain Number>\n",argv[0]);
      return -1;
   }
   
   char filename[32];
   sprintf(filename,"../raw_data/%s.dat",argv[1]);

   int ChainNum;
   ChainNum = atoi(argv[2]);
   
   FILE *fp;
   if ((fp = fopen(filename,"rb"))==NULL){
      printf("File open Error\n");
      return -1;
   }

   /*    */
   unsigned int  readnum;
   unsigned char rawdata[33000];

   unsigned long long int  totalread;
   
   /*  Header/Footer Packet  */
   int MagicWord;
   int TYPE;
   unsigned int Length;
   unsigned int EventID;
   int Trailer;

   /*  Data Packet  */
   int hitnum;
   int DataType;
   int board_num;
   int ch_num;
   int stop_ID;
   int stop_num;
   int data_length;
   int data[1025];
   int time[1025];
   int keyword;
   int status;
   int checksum;
   int i,j,l;
   int k=0;
   int stop_ch;

   while (1) {
      for (l=0; l<ChainNum; l++) {
         totalread = 0;
         
         /* Magic Word Read */
         readnum   = fread(rawdata,1,4,fp);
         MagicWord = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
         
         if (readnum==0) {
            break;
         } else if (readnum!=4) {
            fclose(fp);
            printf("Magic Word Read Error.\n");
            return -1;
         }
         
         if (MagicWord!=0x89ABCDEF) {
            printf("Magic Word Read Error.\n");
            fclose(fp);
            return -1;
         }
         
         totalread += readnum;
         
         /* TYPE Read */
         readnum = fread(rawdata+totalread,1,4,fp);
         TYPE    = (((rawdata[totalread]&0xFF)<<16) + ((rawdata[totalread+1]&0xFF)<<8) + (rawdata[totalread+2]&0xFF));
         
         if (TYPE!=0xFF0000) {
            printf("TYPE Read Error.\n");
            fclose(fp);
            return -1;
         }
         
         totalread += readnum;
         
         /* Length Read */
         readnum = fread(rawdata+totalread,1,4,fp);
         Length  = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
         
         //printf("Length is %d.\n",Length);
         
         totalread += readnum;
         
         /* Event ID Read */
         readnum = fread(rawdata+totalread,1,4,fp);
         EventID = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
         
         //printf("Event ID is %d.\n",EventID);
         
         totalread += readnum;
         
         //printf("Total Read (Header) Number is %d.\n",totalread);
         
         /* Data Packet Read */
         hitnum = Length/2060;
         //printf("Hit Channel Number is %d.\n",hitnum);
         
         for (i=0; i<hitnum; i++) {
            
            readnum  = fread(rawdata+totalread,1,2,fp);
            DataType = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
            if (DataType!=0x1234) {
               printf("Data Type Read Error.\n");
               fclose(fp);
               return -1;
            }
            totalread += readnum;
            
            readnum   = fread(rawdata+totalread,1,2,fp);
            board_num = (rawdata[totalread]&0xFF);
            ch_num    = (rawdata[totalread+1]&0xFF);
            //printf("Board Number : %d\n",board_num);
            //printf("Channel Number : %d\n",ch_num+1);
            totalread += readnum;
            
            readnum = fread(rawdata+totalread,1,2,fp);
            stop_ID = ((rawdata[totalread]&0xFC)>>2);
            stop_ch = (((rawdata[totalread]&0x03)<<8) + (rawdata[totalread+1]&0xFF));
            if (stop_ID!=0x3F) {
               printf("stop ID Read Error.\n");
               fclose(fp);
               return -1;
            }
            //printf("Stop ID : %d\n",stop_ID);
            //printf("Stop Number : %d\n",stop_ch);
            totalread += readnum;
            
            readnum     = fread(rawdata+totalread,1,2,fp);
            data_length = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
            //printf("Data Length : %d\n",data_length);
            totalread += readnum;
            
            //printf("Total Read (Packet Header) Number is %d.\n",totalread);
            
            readnum = fread(rawdata+totalread,1,data_length,fp);
            for (j=0; j<readnum; j=j+2) {
               int n = j/2;
               data[n] = ((rawdata[totalread+j]&0xFF)<<8) + (rawdata[totalread+j+1]&0xFF);
               time[n] = n;
            }
            totalread += readnum;
            
            readnum = fread(rawdata+totalread,1,2,fp);
            keyword = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
            if (keyword!=0x5678) {
               printf("keyword Read Error.\n");
               fclose(fp);
               return -1;
            }
            //printf("Key Word : 0x%x\n",keyword);
            totalread += readnum;
            
            readnum  = fread(rawdata+totalread,1,2,fp);
            status   = (rawdata[totalread]&0xFF);
            checksum = (rawdata[totalread+1]&0xFF);
            //printf("Status : 0x%x\n",status);
            //printf("Check Sum : 0x%x\n",checksum);
            totalread += readnum;
         }
         
         //printf ("Total Read (Packet Header) Number is %d.\n",totalread);
         
         /* Trailer Read */
         readnum = fread(rawdata+totalread,1,4,fp);
         Trailer = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
         
         if (Trailer!=0xFEDCBA98) {
            printf("Trailer Error\n");
            fclose(fp);
            return -1;
         }
         
         printf("Trailer : 0x%X \n",Trailer);
         
         totalread += readnum;
      }
            
      if (readnum==0) {
         printf("File Check (Packet Frame) OK\n");
         break;
      }

      k=k+1;
      printf("%d times check finished.\n",k);
//    printf("One Event Read : %d\n",totalread);
   }
   
   fclose(fp);
   
   return 0;

}
