`timescale 1ns / 1ps

////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer:
//
// Create Date:   20:28:39 01/06/2015
// Design Name:   fifo
// Module Name:   C:/Users/Administrator/Dropbox/telescope/firmware/debug/v4.0_4tele_SB1/svx4/fifo_testbench.v
// Project Name:  multi_chip
// Target Device:  
// Tool versions:  
// Description: 
//
// Verilog Test Fixture created by ISE for module: fifo
//
// Dependencies:
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
////////////////////////////////////////////////////////////////////////////////

module fifo_testbench;

   // Inputs
   reg ACTIVE_IN;
   reg OPERATE_CLK_IN;
   reg READOUT_CLK_IN;
   reg RESET_IN;
   reg [7:0] INPUT_DATA;
   reg 	     READ_MODE_IN;
   reg 	     FIFO_RE_IN;
   reg 	     OBDV_IN;
   reg 	     FIFO_FORCE_WE;	     

   // Outputs
   wire [7:0] OUTPUT_DATA;
   wire       FIFO_EMPTY_OUT;
   wire       FIFO_FULL_OUT;
   wire       DATA_VALID_OUT;

   // Instantiate the Unit Under Test (UUT)
   fifo_mod uut (
		 .ACTIVE_IN(ACTIVE_IN), 
		 .OPERATE_CLK_IN(OPERATE_CLK_IN), 
		 .READOUT_CLK_IN(READOUT_CLK_IN), 
		 .RESET_IN(RESET_IN), 
		 .INPUT_DATA(INPUT_DATA), 
		 .READ_MODE_IN(READ_MODE_IN), 
		 .FIFO_RE_IN(FIFO_RE_IN), 
		 .OBDV_IN(OBDV_IN),
		 .FIFO_FORCE_WE(FIFO_FORCE_WE),
		 .OUTPUT_DATA(OUTPUT_DATA), 
		 .FIFO_EMPTY_OUT(FIFO_EMPTY_OUT), 
		 .FIFO_FULL_OUT(FIFO_FULL_OUT), 
		 .DATA_VALID_OUT(DATA_VALID_OUT)
		 );


   //-------------------------------------------
   // generating 40 MHz CLK
   //-------------------------------------------
   parameter CYCLE40M = 25.0;
   initial begin
      OPERATE_CLK_IN <= 1'b0;
      #50; //wait for CLK
      forever begin
	 OPERATE_CLK_IN <= ~OPERATE_CLK_IN; #(CYCLE40M/2.0);
      end
   end

   
   //-------------------------------------------
   // generating 25 MHz CLK
   //-------------------------------------------
   parameter CYCLE25M = 40.0;
   initial begin
      READOUT_CLK_IN <= 1'b0;
      #50; //wait for CLK
      forever begin
	 READOUT_CLK_IN <= ~READOUT_CLK_IN; #(CYCLE25M/2.0);
      end
   end


   //-------------------------------------------
   // generating 20 MHz CLK
   //-------------------------------------------
   reg       CLK_20M;
   parameter CYCLE20M = 50.0;
   initial begin
      CLK_20M <= 1'b0;
      #50; //wait for CLK
      forever begin
	 CLK_20M <= ~CLK_20M; #(CYCLE20M/2.0);
      end
   end
   

   //-------------------------------------------
   // Emulating Data and OBDV
   //-------------------------------------------
   reg       emu_data_r;
   reg [63:0] data_cnt_r;

   initial begin
      INPUT_DATA = 1'b0;
      OBDV_IN = 1'b0;
      data_cnt_r = 12'b0;
   end
   
   // always @(negedge OPERATE_CLK_IN)begin
   //    if(emu_data_r == 1'b1)begin
   // 	 OBDV_IN <= ~OBDV_IN;
   //    end else begin
   // 	 OBDV_IN <= 1'b0;
   //    end
   // end

   // always @(CLK_20M or negedge emu_data_r)begin
   //    if(emu_data_r == 1'b1)begin
   // 	 data_cnt_r[63:0] <= data_cnt_r[63:0] + 64'd1;
   //    end else begin
   // 	 data_cnt_r[63:0] <= 12'd0;
   //    end 
   // end
   
   // always @(OBDV_IN or negedge emu_data_r)begin
   //    if(emu_data_r == 1'b1)begin
   // 	 INPUT_DATA[7:0] <=  INPUT_DATA[7:0] - 8'd2;
   //    end else begin
   // 	 INPUT_DATA[7:0] <= 8'd255;
   //    end
   // end


   initial begin
      FIFO_RE_IN = 1'b0;
      FIFO_FORCE_WE = 1'b0;
   end
   
   always @(posedge READOUT_CLK_IN)begin
      // FIFO_RE_IN <= ~FIFO_EMPTY_OUT;
   end
   
   initial begin
      // Initialize Inputs
      ACTIVE_IN = 1'b0;
      RESET_IN = 1'b0;
      READ_MODE_IN = 1'b0;

      // Wait 100 ns for global reset to finish
      #100;
      ACTIVE_IN = 1'b1;
      READ_MODE_IN = 1'b1;
      
      // Add stimulus here
      // #7000;
      // RESET_IN = 1'b1;
      
   end

   initial begin
      emu_data_r = 1'b0;

      #300;
      
      #25;
      OBDV_IN = 1'b1;
      INPUT_DATA[7:0] = INPUT_DATA[7:0] + 8'd2;
      #25;
      OBDV_IN = 1'b0;
      INPUT_DATA[7:0] = INPUT_DATA[7:0] + 8'd2;
      #25;
      OBDV_IN = 1'b1;
      INPUT_DATA[7:0] = INPUT_DATA[7:0] + 8'd2;
      #25;
      OBDV_IN = 1'b0;
      INPUT_DATA[7:0] = INPUT_DATA[7:0] + 8'd2;
      #25;
      OBDV_IN = 1'b1;
      INPUT_DATA[7:0] = INPUT_DATA[7:0] + 8'd2;
      #25;
      OBDV_IN = 1'b0;
      INPUT_DATA[7:0] = INPUT_DATA[7:0] + 8'd2;
      #25;
      OBDV_IN = 1'b1;
      INPUT_DATA[7:0] = INPUT_DATA[7:0] + 8'd2;
      #25;
      OBDV_IN = 1'b0;
      INPUT_DATA[7:0] = INPUT_DATA[7:0] + 8'd2;
      #25;
      OBDV_IN = 1'b1;
      INPUT_DATA[7:0] = INPUT_DATA[7:0] + 8'd2;
      #25;
      OBDV_IN = 1'b0;
      INPUT_DATA[7:0] = INPUT_DATA[7:0] + 8'd2;
      #25;
      INPUT_DATA[7:0] = 8'd0;

      #250;
      FIFO_RE_IN = 1'b1;
      #(25*3)
      FIFO_RE_IN = 1'b0;            
      
      // #600;
      // emu_data_r = 1'b1;
      // #300;
      // emu_data_r = 1'b0;
      
      // #1000;
      // emu_data_r = 1'b0;

      // forever begin
      // 	 #2100;
      // 	 emu_data_r = 1'b1;
      // 	 #1000;
      // 	 emu_data_r = 1'b0;
      // end
      
   end
   
endmodule

