`timescale 1ns / 1ps

////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer:
//
// Create Date:   02:37:48 12/05/2014
// Design Name:   header_tele
// Module Name:   Z:/Desktop/v1.0_4tele_SB1/sim/header_testbench.v
// Project Name:  multi_chip
// Target Device:  
// Tool versions:  
// Description: 
//
// Verilog Test Fixture created by ISE for module: header_tele
//
// Dependencies:
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
////////////////////////////////////////////////////////////////////////////////

module header_testbench;

   // Inputs
   reg OPERATE_CLK_IN;
   reg ACTIVE;
   reg [31:0] EVENT_NUM_IN;
   reg [23:0] TIMESTAMP_IN;
   reg 	      TRIGGER_IN;
   reg 	      TRIGGER_RCVED_IN;
   reg 	      RESET_IN;

   // Outputs
   wire [7:0] HEADER_OUT;
   wire       HEADER_WE;

   // Instantiate the Unit Under Test (UUT)
   header_tele uut (
		    .OPERATE_CLK_IN(OPERATE_CLK_IN), 
		    .ACTIVE(ACTIVE), 
		    .EVENT_NUM_IN(EVENT_NUM_IN), 
		    .TIMESTAMP_IN(TIMESTAMP_IN), 
		    .TRIGGER_IN(TRIGGER_IN), 
		    .TRIGGER_RCVED_IN(TRIGGER_RCVED_IN),
		    .RESET_IN(RESET_IN),
		    .HEADER_OUT(HEADER_OUT), 
		    .HEADER_WE(HEADER_WE)
		    );
   
   parameter CYCLE40M = 25.0;

   //-------------------------------------------
   // generating 40 MHz CLK
   //-------------------------------------------
   initial begin
      OPERATE_CLK_IN <= 1'b0;
      #150; //wait for CLK
      forever begin
	 OPERATE_CLK_IN <= ~OPERATE_CLK_IN; #(CYCLE40M/2.0);
      end
   end

   //-------------------------------------------
   // generating EVENT_NUM  and TIMESTAMP
   //-------------------------------------------
   initial begin
      EVENT_NUM_IN <= 32'd0;
      TIMESTAMP_IN <= 24'd0;
      #300; //wait for CLK
      forever begin
	 #1000;
	 EVENT_NUM_IN <= EVENT_NUM_IN + 32'd1;
	 TIMESTAMP_IN <= TIMESTAMP_IN + 24'd100;
      end
   end

   //-------------------------------------------
   // generating trigger
   //-------------------------------------------
   initial begin
      TRIGGER_IN <= 1'b0;
      TRIGGER_RCVED_IN <= 1'b0;
      #295; //wait for CLK
      forever begin
	 TRIGGER_IN <= 1'b1;
	 #50 TRIGGER_IN <= 1'b0;
	 #900 TRIGGER_RCVED_IN <= 1'b1;
	 #50 TRIGGER_RCVED_IN <= 1'b0;
	 #100;
      end
   end

   //
   initial begin
      // Initialize Inputs
      ACTIVE <= 1'b0;
      RESET_IN <= 1'b0;

      // Wait 100 ns for global reset to finish
      #200;
      ACTIVE <= 1'b1;
      
      // Add stimulus here
      #10000;
      RESET_IN <= 1'b1;
      #50;
      ACTIVE <= 1'b0;
      #50;
      RESET_IN <= 1'b0;
      
   end

   
endmodule

