// include in ucf
// INST "*/double_ff_register_first" TNM = "double_ff_register";
// TIMESPEC TS_DOUBLE_FF = TO "double_ff_register" TIG;

module double_ff #(
    parameter INIT = 1'b0
) (
    input wire idata,
    input wire oclk,
    output wire odata
);
    wire temp;

    (* HU_SET="double_ff_registers", RLOC="X0Y0", ASYNC_REG="TRUE" *)
    FDRSE #(
        .INIT(INIT)     // Initial value of register (1'b0 or 1'b1)
    ) double_ff_register_first (
        .Q(temp),       // Data output
        .C(oclk),       // Clock input
        .CE(1'b1),      // Clock enable input
        .D(idata),      // Data input
        .R(1'b0),       // Synchronous reset input
        .S(1'b0)        // Synchronous set input
    );

    (* HU_SET="double_ff_registers", RLOC="X0Y0" *)
    FDRSE #(
        .INIT(INIT)     // Initial value of register (1'b0 or 1'b1)
    ) double_ff_register_second (
        .Q(odata),      // Data output
        .C(oclk),       // Clock input
        .CE(1'b1),      // Clock enable input
        .D(temp),       // Data input
        .R(1'b0),       // Synchronous reset input
        .S(1'b0)        // Synchronous set input
    );

endmodule
