module multisample_TDC
  #(parameter INIT = 1'b0)
   (
    CLK_0_IN,
    CLK_90_IN,
    CLK_180_IN,
    CLK_270_IN,
    START_IN,
    DATA_OUT
    );
   
   input 	  CLK_0_IN;
   input 	  CLK_90_IN;
   input 	  CLK_180_IN;
   input 	  CLK_270_IN;

   input          START_IN;
   output [1:0]   DATA_OUT;

   wire [3:0] 	  encoded_data_s;
   

   ////////////////////////////////////////////////////////////////////////////////
   // Y0 (skew 0 degree)
   ////////////////////////////////////////////////////////////////////////////////
   wire [2:0] 	  temp0_s;   
   (* HU_SET="multi_sampling", RLOC="X0Y0", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x0y0 (
			   .Q(temp0_s[0]), // Data output
			   .C(CLK_0_IN),   // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(START_IN),   // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );

   (* HU_SET="multi_sampling", RLOC="X1Y0", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x1y0 (
			   .Q(temp0_s[1]), // Data output
			   .C(CLK_0_IN),   // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(temp0_s[0]), // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );

   (* HU_SET="multi_sampling", RLOC="X2Y0", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x2y0 (
			   .Q(temp0_s[2]), // Data output
			   .C(CLK_0_IN),   // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(temp0_s[1]), // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );
   
   (* HU_SET="multi_sampling", RLOC="X3Y0", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x3y0 (
			   .Q(encoded_data_s[0]),// Data output
			   .C(CLK_0_IN),   // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(temp0_s[2]), // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );


   ////////////////////////////////////////////////////////////////////////////////
   // Y1 (skew 90 degree)
   ////////////////////////////////////////////////////////////////////////////////
   wire [2:0] 	  temp1_s;   
   (* HU_SET="multi_sampling", RLOC="X0Y1", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x0y1 (
			   .Q(temp1_s[0]), // Data output
			   .C(CLK_90_IN),  // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(START_IN),   // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );

   (* HU_SET="multi_sampling", RLOC="X1Y1", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x1y1 (
			   .Q(temp1_s[1]), // Data output
			   .C(CLK_0_IN),   // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(temp1_s[0]), // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );

   (* HU_SET="multi_sampling", RLOC="X2Y1", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x2y1 (
			   .Q(temp1_s[2]), // Data output
			   .C(CLK_0_IN),   // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(temp1_s[1]), // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );
   
   (* HU_SET="multi_sampling", RLOC="X3Y1", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x3y1 (
			   .Q(encoded_data_s[1]),// Data output
			   .C(CLK_0_IN),   // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(temp1_s[2]), // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );

   
   ////////////////////////////////////////////////////////////////////////////////
   // Y2 (skew 180 degree)
   ////////////////////////////////////////////////////////////////////////////////
   wire [2:0] 	  temp2_s;   
   (* HU_SET="multi_sampling", RLOC="X0Y2", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x0y2 (
			   .Q(temp2_s[0]), // Data output
			   .C(CLK_180_IN), // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(START_IN),   // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );

   (* HU_SET="multi_sampling", RLOC="X1Y2", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x1y2 (
			   .Q(temp2_s[1]), // Data output
			   .C(CLK_90_IN),  // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(temp2_s[0]), // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );

   (* HU_SET="multi_sampling", RLOC="X2Y2", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x2y2 (
			   .Q(temp2_s[2]), // Data output
			   .C(CLK_0_IN),   // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(temp2_s[1]), // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );
   
   (* HU_SET="multi_sampling", RLOC="X3Y2", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x3y2 (
			   .Q(encoded_data_s[2]),// Data output
			   .C(CLK_0_IN),   // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(temp2_s[2]), // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );

   
   ////////////////////////////////////////////////////////////////////////////////
   // Y3 (skew 270 degree)
   ////////////////////////////////////////////////////////////////////////////////
   wire [2:0] 	  temp3_s;   
   (* HU_SET="multi_sampling", RLOC="X0Y3", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x0y3 (
			   .Q(temp3_s[0]), // Data output
			   .C(CLK_270_IN), // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(START_IN),   // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );

   (* HU_SET="multi_sampling", RLOC="X1Y3", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x1y3 (
			   .Q(temp3_s[1]), // Data output
			   .C(CLK_180_IN), // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(temp3_s[0]), // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );

   (* HU_SET="multi_sampling", RLOC="X2Y3", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x2y3 (
			   .Q(temp3_s[2]), // Data output
			   .C(CLK_90_IN),  // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(temp3_s[1]), // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );
   
   (* HU_SET="multi_sampling", RLOC="X3Y3", ASYNC_REG="TRUE" *)
   FDRSE #(.INIT(INIT) /* Initial value of register (1'b0 or 1'b1) */
	   ) mltsmpl_x3y3 (
			   .Q(encoded_data_s[3]),// Data output
			   .C(CLK_0_IN),   // Clock input
			   .CE(1'b1),      // Clock enable input
			   .D(temp3_s[2]), // Data input
			   .R(1'b0),       // Synchronous reset input
			   .S(1'b0)        // Synchronous set input
			   );


   ////////////////////////////////////////////////////////////////////////////////
   // decoder
   ////////////////////////////////////////////////////////////////////////////////
   function [2:0] decode_f;
      input [3:0] multisampling_data;
      case(multisampling_data)
	4'b1000 : decode_f = 3'b0_10;
	4'b1100 : decode_f = 3'b0_01;
	4'b1110 : decode_f = 3'b0_00;
	4'b1111 : decode_f = 3'b0_11;
	default : decode_f = 3'b1_00;
      endcase // case (multisampling_data)
   endfunction
   
   wire [2:0] 	  decoded_data_s;
   assign decoded_data_s[2:0] = decode_f(encoded_data_s[3:0]);

   reg [2:0] 	  decoded_data_buf_r = 3'b100;
   reg [2:0] 	  data_out_r = 3'b100;
   always @(posedge CLK_0_IN)begin
      decoded_data_buf_r[2:0] <= decoded_data_s[2:0];
      
      if(decoded_data_buf_r[2] == 1'b1
	 && decoded_data_s[2] == 1'b0)begin
	data_out_r[1:0] <= decoded_data_s[1:0];
      end
   end

   assign DATA_OUT[1:0] = data_out_r[1:0];
   
endmodule
