module trigger(
	       TRIGGER_CLK,
	       OPERATE_CLK,
	       HEADER_CLK,
	       TS_CLK,

	       ACTIVE_IN,
	       BUSY_IN,

	       START_IN,
	       PAUSE_IN,
	       STOP_IN,
	       RESET_IN,
	       INT_TRIG_IN,

	       NIM_TRIGGER,      // IN
	       TRIGGER_RCVED_IN,

	       TRIGGER_OUT,
	       TRIGGERED_FLAG,   // OUT
	       RUNNING_FLAG,     // OUT

	       STATUS_IN,
	       HEADER_OUT,
	       HEADER_WE
	       );

   input           TRIGGER_CLK;	        // For receiving Trigger (recommended 50MHz)
   input 	   OPERATE_CLK;		// For making trigger signal
   input 	   HEADER_CLK;		// For Header writing
   input 	   TS_CLK;		// For Timestamp counter
   
   input 	   ACTIVE_IN;		// Connection Active Flag
   input 	   BUSY_IN;		// Busy (It Cannot be Triggered)
   
   input 	   START_IN;		// For START or RESUME Command
   input 	   PAUSE_IN;            // For PAUSE command
   input 	   STOP_IN;		// For STOP or PAUSE Command
   input 	   RESET_IN;		// System RESET
   input 	   INT_TRIG_IN;		// Switch to Internal Trigger
   
   input 	   NIM_TRIGGER;  	// Trigger input
   input 	   TRIGGER_RCVED_IN;    // Flag meaning trigger is received normally
   
   output  	   TRIGGER_OUT;		// Pulse shaped trigger
   output  	   TRIGGERED_FLAG;	// Trigger flag
   output  	   RUNNING_FLAG;	// indicate DAQ is running

   input [7:0] 	   STATUS_IN;	        // Status parameter
   output [7:0]    HEADER_OUT;		// Event Header output
   output 	   HEADER_WE;		// Event Header write enable


   /////////////////////////////////////////////////////////////////////////////////////

   wire [31:0] trigger_cnt_s;
   trig_evnum trig_evnum(
			 .TRIGGER_CLK_IN(TRIGGER_CLK),
			 .OPERATE_CLK_IN(OPERATE_CLK),
			 .ACTIVE_IN(ACTIVE_IN),
			 .BUSY_IN(BUSY_IN),
			 .START_IN(START_IN),
			 .PAUSE_IN(PAUSE_IN),
			 .STOP_IN(STOP_IN),
			 .RESET_IN(RESET_IN),
			 .NIM_TRIGGER(NIM_TRIGGER),
			 .TRIGGER_RCVED_IN(TRIGGER_RCVED_IN),
			 .INT_TRIG_IN(INT_TRIG_IN),
			 .TRIGGER_OUT(TRIGGER_OUT),
			 .TRIGGERED_FLAG(TRIGGERED_FLAG),
			 .RUNNING_FLAG(RUNNING_FLAG),
			 .EVENT_NUM(trigger_cnt_s[31:0])
			 );

   wire [23:0] timestamp_s;
   time_stamp time_stamp(
			 .CLK(HEADER_CLK),
			 .TS_CLK(TS_CLK),
			 .TRIGGER_IN(TRIGGERED_FLAG),
			 .RESET(STOP_IN | ~ACTIVE_IN),
			 .BUSY(BUSY_IN),
			 .TIMESTAMP_OUT(timestamp_s[23:0])
			 );

   header_tele header(
		      .OPERATE_CLK_IN(HEADER_CLK),
		      .ACTIVE(ACTIVE_IN),
		      .EVENT_NUM_IN(trigger_cnt_s[31:0]),
		      .TIMESTAMP_IN(timestamp_s[23:0]),
		      .STATUS_IN(STATUS_IN[7:0]),
		      .TRIGGER_IN(TRIGGER_OUT),
		      .TRIGGER_RCVED_IN(TRIGGER_RCVED_IN),
		      .RESET_IN(RESET_IN),
		      .HEADER_OUT(HEADER_OUT[7:0]),
		      .HEADER_WE(HEADER_WE)
		      );
   
endmodule
